<?php
/**
 * Analytics Dashboard - gsadm
 * Access at: /gsadm
 */

// Security: Simple password protection (change in production)
session_start();

$admin_password = 'jokeadmin123!'; // CHANGE THIS IN PRODUCTION!
$is_logged_in = isset($_SESSION['gsadm_logged_in']) && $_SESSION['gsadm_logged_in'] === true;

// Handle login
if (isset($_POST['password'])) {
    if ($_POST['password'] === $admin_password) {
        $_SESSION['gsadm_logged_in'] = true;
        $is_logged_in = true;
    } else {
        $login_error = 'Invalid password';
    }
}

// Handle logout
if (isset($_GET['logout'])) {
    $_SESSION['gsadm_logged_in'] = false;
    session_destroy();
    header('Location: /gsadm');
    exit;
}

// If not logged in, show login form
if (!$is_logged_in) {
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Analytics Dashboard - Login</title>
        <style>
            * { margin: 0; padding: 0; box-sizing: border-box; }
            body {
                font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                padding: 20px;
            }
            .login-box {
                background: white;
                border-radius: 12px;
                padding: 40px;
                box-shadow: 0 20px 60px rgba(0,0,0,0.3);
                max-width: 400px;
                width: 100%;
            }
            h1 {
                color: #333;
                margin-bottom: 10px;
                font-size: 24px;
            }
            p {
                color: #666;
                margin-bottom: 30px;
                font-size: 14px;
            }
            .form-group {
                margin-bottom: 20px;
            }
            label {
                display: block;
                color: #333;
                margin-bottom: 8px;
                font-size: 14px;
                font-weight: 500;
            }
            input[type="password"] {
                width: 100%;
                padding: 12px;
                border: 2px solid #e0e0e0;
                border-radius: 8px;
                font-size: 16px;
                transition: border-color 0.3s;
            }
            input[type="password"]:focus {
                outline: none;
                border-color: #667eea;
            }
            button {
                width: 100%;
                padding: 12px;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                color: white;
                border: none;
                border-radius: 8px;
                font-size: 16px;
                font-weight: 600;
                cursor: pointer;
                transition: transform 0.2s, box-shadow 0.2s;
            }
            button:hover {
                transform: translateY(-2px);
                box-shadow: 0 10px 20px rgba(102, 126, 234, 0.4);
            }
            .error {
                background: #fee;
                color: #c33;
                padding: 12px;
                border-radius: 8px;
                margin-bottom: 20px;
                font-size: 14px;
            }
        </style>
    </head>
    <body>
        <div class="login-box">
            <h1>Analytics Dashboard</h1>
            <p>Please enter the password to access analytics</p>
            <?php if (isset($login_error)): ?>
                <div class="error"><?= htmlspecialchars($login_error) ?></div>
            <?php endif; ?>
            <form method="POST">
                <div class="form-group">
                    <label for="password">Password</label>
                    <input type="password" id="password" name="password" required autofocus>
                </div>
                <button type="submit">Login</button>
            </form>
        </div>
    </body>
    </html>
    <?php
    exit;
}

// Load analytics tracker
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../includes/analytics-tracker.php';

// Handle AJAX requests
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['analytics_action'])) {
    header('Content-Type: application/json');
    
    $action = $_POST['analytics_action'] ?? '';
    $result = ['success' => false, 'message' => 'Invalid action'];
    
    try {
        switch ($action) {
            case 'delete_visit':
                $visitId = trim($_POST['visit_id'] ?? '');
                if (!empty($visitId) && function_exists('delete_analytics_visit')) {
                    delete_analytics_visit($visitId);
                    $result = ['success' => true, 'message' => 'Visit deleted successfully'];
                }
                break;
                
            case 'clear_analytics':
                if (function_exists('clear_analytics')) {
                    clear_analytics();
                    $result = ['success' => true, 'message' => 'All analytics data cleared successfully'];
                }
                break;
        }
    } catch (Exception $e) {
        $result = ['success' => false, 'message' => 'Error: ' . $e->getMessage()];
    }
    
    echo json_encode($result);
    exit;
}

// Load analytics data
$analyticsDays = (int)($_GET['days'] ?? 30);
$analyticsStats = get_analytics_stats($analyticsDays);
$analytics = load_analytics();
$recentVisits = array_slice(array_reverse($analytics['visits'] ?? []), 0, 100); // Last 100 visits

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Analytics Dashboard</title>
    <meta name="robots" content="noindex, nofollow">
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            background: #f5f7fa;
            color: #333;
            line-height: 1.6;
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 20px 30px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .header h1 {
            font-size: 24px;
            margin-bottom: 5px;
        }
        .header p {
            opacity: 0.9;
            font-size: 14px;
        }
        .header-actions {
            margin-top: 15px;
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }
        .btn {
            padding: 8px 16px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 500;
            transition: all 0.2s;
            text-decoration: none;
            display: inline-block;
        }
        .btn-primary {
            background: rgba(255,255,255,0.2);
            color: white;
            border: 1px solid rgba(255,255,255,0.3);
        }
        .btn-primary:hover {
            background: rgba(255,255,255,0.3);
        }
        .btn-danger {
            background: #dc3545;
            color: white;
        }
        .btn-danger:hover {
            background: #c82333;
        }
        .select {
            padding: 8px 12px;
            border: 1px solid rgba(255,255,255,0.3);
            border-radius: 6px;
            background: rgba(255,255,255,0.2);
            color: white;
            font-size: 14px;
            cursor: pointer;
        }
        .select option {
            background: #667eea;
            color: white;
        }
        .container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 30px;
        }
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        .stat-card {
            background: white;
            border-radius: 12px;
            padding: 25px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
            transition: transform 0.2s, box-shadow 0.2s;
        }
        .stat-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 20px rgba(0,0,0,0.1);
        }
        .stat-card h3 {
            font-size: 32px;
            color: #667eea;
            margin-bottom: 8px;
        }
        .stat-card p {
            color: #666;
            font-size: 14px;
        }
        .stat-card .icon {
            float: right;
            font-size: 40px;
            opacity: 0.2;
        }
        .charts-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        .chart-card {
            background: white;
            border-radius: 12px;
            padding: 25px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        .chart-card h3 {
            font-size: 18px;
            margin-bottom: 20px;
            color: #333;
        }
        .chart-container {
            position: relative;
            height: 300px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            background: white;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        th, td {
            padding: 12px 15px;
            text-align: left;
            border-bottom: 1px solid #eee;
        }
        th {
            background: #f8f9fa;
            font-weight: 600;
            color: #333;
            font-size: 14px;
        }
        td {
            font-size: 14px;
            color: #666;
        }
        tr:hover {
            background: #f8f9fa;
        }
        .badge {
            display: inline-block;
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: 500;
        }
        .badge-success {
            background: #d4edda;
            color: #155724;
        }
        .badge-info {
            background: #d1ecf1;
            color: #0c5460;
        }
        .badge-secondary {
            background: #e2e3e5;
            color: #383d41;
        }
        .btn-sm {
            padding: 4px 8px;
            font-size: 12px;
        }
        .text-center {
            text-align: center;
        }
        .text-muted {
            color: #999;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>📊 Analytics Dashboard</h1>
        <p>Website traffic and visitor statistics</p>
        <div class="header-actions">
            <select class="select" id="analyticsDays" onchange="window.location.href='?days=' + this.value">
                <option value="7" <?= $analyticsDays === 7 ? 'selected' : '' ?>>Last 7 days</option>
                <option value="30" <?= $analyticsDays === 30 ? 'selected' : '' ?>>Last 30 days</option>
                <option value="90" <?= $analyticsDays === 90 ? 'selected' : '' ?>>Last 90 days</option>
                <option value="365" <?= $analyticsDays === 365 ? 'selected' : '' ?>>Last year</option>
            </select>
            <button class="btn btn-danger" onclick="clearAllAnalytics()">🗑️ Clear All</button>
            <a href="?logout=1" class="btn btn-primary">🚪 Logout</a>
        </div>
    </div>

    <div class="container">
        <!-- Statistics Cards -->
        <div class="stats-grid">
            <div class="stat-card">
                <span class="icon">👁️</span>
                <h3><?= number_format($analyticsStats['total_visits']) ?></h3>
                <p>Total Visits</p>
            </div>
            <div class="stat-card">
                <span class="icon">👥</span>
                <h3><?= number_format($analyticsStats['unique_ips']) ?></h3>
                <p>Unique Visitors</p>
            </div>
            <div class="stat-card">
                <span class="icon">🖱️</span>
                <h3><?= number_format($analyticsStats['total_clicks'] ?? 0) ?></h3>
                <p>Total Clicks</p>
            </div>
            <div class="stat-card">
                <span class="icon">🧭</span>
                <h3><?= number_format($analyticsStats['total_navigations'] ?? 0) ?></h3>
                <p>Page Navigations</p>
            </div>
            <div class="stat-card">
                <span class="icon">📢</span>
                <h3><?= number_format($analyticsStats['total_modal_views'] ?? 0) ?></h3>
                <p>Proposal Modal Views</p>
            </div>
            <div class="stat-card">
                <span class="icon">👆</span>
                <h3><?= number_format($analyticsStats['users_with_clicks'] ?? 0) ?></h3>
                <p>Users Who Clicked</p>
            </div>
            <div class="stat-card">
                <span class="icon">🚶</span>
                <h3><?= number_format($analyticsStats['users_with_navigation'] ?? 0) ?></h3>
                <p>Users Who Navigated</p>
            </div>
            <div class="stat-card">
                <span class="icon">🔍</span>
                <h3><?= count($analyticsStats['search_queries'] ?? []) ?></h3>
                <p>Search Queries</p>
            </div>
        </div>

        <!-- Charts -->
        <div class="charts-grid">
            <div class="chart-card">
                <h3>🌐 Browsers</h3>
                <div class="chart-container">
                    <canvas id="browserChart"></canvas>
                </div>
            </div>
            <div class="chart-card">
                <h3>🔗 Top Referrals</h3>
                <div class="chart-container">
                    <canvas id="referralChart"></canvas>
                </div>
            </div>
            <div class="chart-card">
                <h3>📅 Daily Visits</h3>
                <div class="chart-container">
                    <canvas id="dailyVisitsChart"></canvas>
                </div>
            </div>
            <div class="chart-card">
                <h3>💻 Operating Systems</h3>
                <div class="chart-container">
                    <canvas id="osChart"></canvas>
                </div>
            </div>
        </div>

        <!-- Most Accessed Pages -->
        <div class="chart-card" style="margin-bottom: 30px;">
            <h3>📄 Most Accessed Pages</h3>
            <table>
                <thead>
                    <tr>
                        <th>Page</th>
                        <th>Visits</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $topPages = array_slice($analyticsStats['pages'] ?? [], 0, 15, true);
                    foreach ($topPages as $page => $count): 
                        $pageName = $page === '/' ? 'Homepage' : ucfirst(str_replace(['/', '-', '_'], ['', ' ', ' '], trim($page, '/')));
                    ?>
                        <tr>
                            <td>
                                <strong><?= htmlspecialchars($pageName) ?></strong>
                                <br><small class="text-muted"><?= htmlspecialchars($page) ?></small>
                            </td>
                            <td><span class="badge badge-info"><?= number_format($count) ?></span></td>
                        </tr>
                    <?php endforeach; ?>
                    <?php if (empty($topPages)): ?>
                        <tr><td colspan="2" class="text-center text-muted">No page visits yet</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Most Accessed Services -->
        <div class="chart-card" style="margin-bottom: 30px;">
            <h3>🔧 Most Accessed Services</h3>
            <table>
                <thead>
                    <tr>
                        <th>Service</th>
                        <th>Visits</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $servicesPages = array_filter($analyticsStats['pages'] ?? [], function($page) {
                        return strpos($page, '/services/') === 0;
                    }, ARRAY_FILTER_USE_KEY);
                    arsort($servicesPages);
                    $topServices = array_slice($servicesPages, 0, 10, true);
                    foreach ($topServices as $page => $count): 
                        $serviceName = ucfirst(str_replace(['/services/', '/', '-', '_'], ['', '', ' ', ' '], $page));
                    ?>
                        <tr>
                            <td>
                                <strong><?= htmlspecialchars($serviceName) ?></strong>
                                <br><small class="text-muted"><?= htmlspecialchars($page) ?></small>
                            </td>
                            <td><span class="badge badge-success"><?= number_format($count) ?></span></td>
                        </tr>
                    <?php endforeach; ?>
                    <?php if (empty($topServices)): ?>
                        <tr><td colspan="2" class="text-center text-muted">No service page visits yet</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Search Queries -->
        <div class="chart-card" style="margin-bottom: 30px;">
            <h3>🔍 Search Engine Queries</h3>
            <table>
                <thead>
                    <tr>
                        <th>Search Query</th>
                        <th>Visits</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    $searchQueries = array_slice($analyticsStats['search_queries'] ?? [], 0, 10, true);
                    foreach ($searchQueries as $queryKey => $count): 
                        $parts = explode(': ', $queryKey, 2);
                        $engine = $parts[0] ?? 'Unknown';
                        $query = $parts[1] ?? $queryKey;
                    ?>
                        <tr>
                            <td><strong><?= htmlspecialchars($engine) ?>:</strong> "<?= htmlspecialchars($query) ?>"</td>
                            <td><span class="badge badge-info"><?= $count ?></span></td>
                        </tr>
                    <?php endforeach; ?>
                    <?php if (empty($searchQueries)): ?>
                        <tr><td colspan="2" class="text-center text-muted">No search engine queries yet</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Recent Visits -->
        <div class="chart-card">
            <h3>📋 Recent Visits</h3>
            <div style="overflow-x: auto;">
                <table>
                    <thead>
                        <tr>
                            <th>Date/Time</th>
                            <th>Page</th>
                            <th>IP Address</th>
                            <th>Browser</th>
                            <th>OS</th>
                            <th>Referral</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($recentVisits as $visit): ?>
                            <tr>
                                <td><?= htmlspecialchars($visit['date'] ?? '') ?></td>
                                <td><?= htmlspecialchars($visit['page'] ?? '/') ?></td>
                                <td><?= htmlspecialchars($visit['ip'] ?? '') ?></td>
                                <td><?= htmlspecialchars($visit['browser'] ?? 'Unknown') ?></td>
                                <td><?= htmlspecialchars($visit['os'] ?? 'Unknown') ?></td>
                                <td>
                                    <?php if (!empty($visit['referral_source'])): ?>
                                        <?php if ($visit['is_search'] ?? false): ?>
                                            <span class="badge badge-success"><?= htmlspecialchars($visit['referral_source']) ?></span>
                                            <?php if (!empty($visit['search_query'])): ?>
                                                <br><small class="text-muted">"<?= htmlspecialchars($visit['search_query']) ?>"</small>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <span class="badge badge-info"><?= htmlspecialchars($visit['referral_source']) ?></span>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <span class="badge badge-secondary">Direct</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <button class="btn btn-danger btn-sm" onclick="deleteVisit('<?= htmlspecialchars($visit['id'] ?? '', ENT_QUOTES) ?>')">🗑️</button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        <?php if (empty($recentVisits)): ?>
                            <tr><td colspan="7" class="text-center text-muted">No visits recorded yet</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script>
        // Browser Chart
        const browserData = <?= json_encode(array_slice($analyticsStats['browsers'] ?? [], 0, 10, true)) ?>;
        const browserCtx = document.getElementById('browserChart');
        if (browserCtx && browserData && Object.keys(browserData).length > 0) {
            new Chart(browserCtx, {
                type: 'doughnut',
                data: {
                    labels: Object.keys(browserData),
                    datasets: [{
                        data: Object.values(browserData),
                        backgroundColor: [
                            '#667eea', '#28a745', '#ffc107', '#dc3545', '#17a2b8',
                            '#6f42c1', '#e83e8c', '#fd7e14', '#20c997', '#6c757d'
                        ]
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: { position: 'bottom' }
                    }
                }
            });
        }

        // Referral Chart
        const referralData = <?= json_encode(array_slice($analyticsStats['referrals'] ?? [], 0, 10, true)) ?>;
        const referralCtx = document.getElementById('referralChart');
        if (referralCtx && referralData && Object.keys(referralData).length > 0) {
            new Chart(referralCtx, {
                type: 'bar',
                data: {
                    labels: Object.keys(referralData),
                    datasets: [{
                        label: 'Visits',
                        data: Object.values(referralData),
                        backgroundColor: '#667eea'
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        y: { beginAtZero: true }
                    },
                    plugins: { legend: { display: false } }
                }
            });
        }

        // Daily Visits Chart
        const dailyData = <?= json_encode($analyticsStats['daily_visits'] ?? []) ?>;
        const dailyCtx = document.getElementById('dailyVisitsChart');
        if (dailyCtx && dailyData && Object.keys(dailyData).length > 0) {
            new Chart(dailyCtx, {
                type: 'line',
                data: {
                    labels: Object.keys(dailyData),
                    datasets: [{
                        label: 'Daily Visits',
                        data: Object.values(dailyData),
                        borderColor: '#28a745',
                        backgroundColor: 'rgba(40, 167, 69, 0.1)',
                        tension: 0.4,
                        fill: true
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: { y: { beginAtZero: true } }
                }
            });
        }

        // OS Chart
        const osData = <?= json_encode(array_slice($analyticsStats['os'] ?? [], 0, 10, true)) ?>;
        const osCtx = document.getElementById('osChart');
        if (osCtx && osData && Object.keys(osData).length > 0) {
            new Chart(osCtx, {
                type: 'pie',
                data: {
                    labels: Object.keys(osData),
                    datasets: [{
                        data: Object.values(osData),
                        backgroundColor: [
                            '#667eea', '#764ba2', '#f093fb', '#4facfe', '#00f2fe',
                            '#43e97b', '#fa709a', '#fee140', '#30cfd0', '#a8edea'
                        ]
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: { position: 'bottom' }
                    }
                }
            });
        }

        function deleteVisit(visitId) {
            if (!confirm('Delete this visit?')) return;
            
            const formData = new FormData();
            formData.append('analytics_action', 'delete_visit');
            formData.append('visit_id', visitId);
            
            fetch('', {
                method: 'POST',
                body: formData
            })
            .then(r => r.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert('Error: ' + data.message);
                }
            });
        }

        function clearAllAnalytics() {
            if (!confirm('Are you sure you want to clear ALL analytics data? This cannot be undone!')) return;
            
            const formData = new FormData();
            formData.append('analytics_action', 'clear_analytics');
            
            fetch('', {
                method: 'POST',
                body: formData
            })
            .then(r => r.json())
            .then(data => {
                if (data.success) {
                    alert('All analytics data cleared successfully');
                    location.reload();
                } else {
                    alert('Error: ' + data.message);
                }
            });
        }
    </script>
</body>
</html>
