# Coventry Mechanic Website

A high-performing, fully indexable template-style website for a Coventry mechanic/garage. Built with PHP, JSON-driven content, and Tailwind CSS.

## Features

- ✅ **Modular PHP Architecture** - Reusable includes for consistency
- ✅ **JSON-Driven Content** - Easy to update without code changes
- ✅ **SEO Optimized** - Meta tags, schema markup, sitemap generation
- ✅ **Quick Quote Calculator** - Interactive estimate tool
- ✅ **Responsive Design** - Mobile-friendly with Tailwind CSS
- ✅ **Fast Loading** - Optimized for performance
- ✅ **Accessibility** - Semantic HTML, ARIA labels
- ✅ **Cookie Compliance** - Cookie banner and policy

## Requirements

- PHP 7.4 or higher
- Apache with mod_rewrite enabled
- Web server with PHP support

## Installation

1. Upload all files to your web server
2. **No configuration needed!** The site auto-detects your domain
3. Edit `data/business.json` with your business information
4. Customize services, pricing, and content in JSON files
5. Ensure `.htaccess` is working (for clean URLs) - `mod_rewrite` must be enabled

### Domain Auto-Detection

The site automatically detects your domain from the HTTP request, so it works on:
- Any domain (example.com, yourdomain.com, etc.)
- Localhost for development
- Subdomains
- With or without `www` prefix

**Optional:** To override auto-detection, edit `config.php` and set `SITE_URL` manually.

## Quick Start

1. **Update Business Info:** Edit `data/business.json`
2. **Customize Services:** Edit `data/services.json`
3. **Set Pricing:** Edit `data/pricing.json`
4. **Add Reviews:** Edit `data/testimonials.json`

See `TEMPLATE_GUIDE.md` for detailed editing instructions.

## File Structure

```
├── data/              # JSON content files
├── partials/          # PHP includes
├── api/               # API endpoints
├── config.php         # Configuration
├── index.php          # Homepage
└── ...                # Other pages
```

## Pages

- **Home** - Quick quote calculator, featured services, reviews
- **Services** - Service hub with categories
- **Service Details** - Individual service pages (slug-based URLs)
- **Pricing** - Transparent pricing guide
- **About** - Business story and values
- **Contact** - Contact form and map
- **Reviews** - Customer testimonials
- **FAQ** - Frequently asked questions
- **Policies** - Privacy, Cookie, Terms

## SEO Features

- Dynamic meta titles and descriptions
- Schema.org structured data (LocalBusiness, Service, FAQPage)
- Automatic sitemap.xml generation
- Clean, slug-based URLs
- Breadcrumb navigation
- Open Graph and Twitter cards

## Customization

All content is in JSON files - no code changes needed for:
- Services
- Pricing
- Testimonials
- FAQs
- Business information

See `TEMPLATE_GUIDE.md` for complete customization guide.

## Support

For questions or issues:
1. Check `TEMPLATE_GUIDE.md`
2. Validate JSON syntax if errors occur
3. Check server PHP version and error logs

## License

Template for use and customization.

---

Built with ❤️ for Coventry mechanics
