<?php
// Check if user has already made a cookie choice or dismissed the banner
$cookie_consent = isset($_COOKIE['cookie_consent']) ? $_COOKIE['cookie_consent'] : null;
$banner_dismissed = isset($_COOKIE['cookie_banner_dismissed']) ? $_COOKIE['cookie_banner_dismissed'] : null;

// Always show banner HTML, but hide it with JavaScript if cookies exist
// This ensures it works even if PHP cookies aren't set properly
?>
<div id="cookie-banner" class="fixed bottom-0 left-0 right-0 bg-gradient-to-r from-gray-800 via-gray-900 to-gray-800 text-white shadow-2xl z-50 transform transition-transform duration-300 ease-in-out" style="transform: translateY(0); display: none;">
    <div class="container mx-auto px-4 py-4">
        <div class="flex flex-col md:flex-row items-start md:items-center justify-between gap-4">
            <div class="flex-1">
                <div class="flex items-start gap-3">
                    <svg class="w-6 h-6 text-blue-400 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4"></path>
                    </svg>
                    <div>
                        <h3 class="font-semibold text-base mb-1">We Value Your Privacy</h3>
                        <p class="text-sm text-gray-300 leading-relaxed">
                            We use cookies to enhance your browsing experience, analyze site traffic, and personalize content. 
                            By clicking "Accept All", you consent to our use of cookies. You can also choose to decline or customize your preferences.
                            <a href="/cookie-policy" class="text-blue-400 hover:text-blue-300 underline font-medium ml-1">Learn more</a>
                        </p>
                    </div>
                </div>
            </div>
            <div class="flex flex-col sm:flex-row gap-2 sm:gap-3 items-stretch sm:items-center">
                <button onclick="acceptCookies()" 
                        class="bg-gradient-to-r from-blue-600 to-purple-600 hover:from-blue-700 hover:to-purple-700 px-6 py-2.5 rounded-lg text-sm font-semibold transition-all shadow-md hover:shadow-lg whitespace-nowrap transform hover:scale-105">
                    Accept All
                </button>
                <button onclick="declineCookies()" 
                        class="bg-gray-700 hover:bg-gray-600 px-6 py-2.5 rounded-lg text-sm font-semibold transition-colors border border-gray-600 hover:border-gray-500 whitespace-nowrap">
                    Decline
                </button>
                <button onclick="dismissCookies()" 
                        class="bg-transparent hover:bg-gray-700 px-4 py-2.5 rounded-lg text-sm font-medium transition-colors border border-gray-600 hover:border-gray-500 text-gray-300 hover:text-white whitespace-nowrap">
                    Dismiss
                </button>
            </div>
        </div>
    </div>
</div>

<style>
#cookie-banner {
    animation: slideUp 0.3s ease-out;
}

#cookie-banner.hidden {
    animation: slideDown 0.3s ease-in;
    transform: translateY(100%);
}

@keyframes slideUp {
    from {
        transform: translateY(100%);
    }
    to {
        transform: translateY(0);
    }
}

@keyframes slideDown {
    from {
        transform: translateY(0);
    }
    to {
        transform: translateY(100%);
    }
}
</style>

<script>
// Helper function to get cookie
function getCookie(name) {
    const value = `; ${document.cookie}`;
    const parts = value.split(`; ${name}=`);
    if (parts.length === 2) return parts.pop().split(';').shift();
    return null;
}

// Helper function to set cookie
function setCookie(name, value, days) {
    const expires = new Date();
    expires.setTime(expires.getTime() + (days * 24 * 60 * 60 * 1000));
    // Use Secure only on HTTPS
    const secure = window.location.protocol === 'https:' ? ';Secure' : '';
    document.cookie = name + '=' + value + ';expires=' + expires.toUTCString() + ';path=/;SameSite=Lax' + secure;
}

// Check if banner should be shown
function shouldShowBanner() {
    const consent = getCookie('cookie_consent');
    const dismissed = getCookie('cookie_banner_dismissed');
    
    // Show banner if no consent and not dismissed
    return !consent && !dismissed;
}

// Show or hide banner based on cookies
function checkAndShowBanner() {
    const banner = document.getElementById('cookie-banner');
    if (!banner) return;
    
    if (shouldShowBanner()) {
        // Show banner with animation
        banner.style.display = 'block';
        setTimeout(() => {
            banner.style.transform = 'translateY(0)';
        }, 10);
    } else {
        // Hide banner if cookies exist
        banner.style.display = 'none';
    }
}

function hideBanner() {
    const banner = document.getElementById('cookie-banner');
    if (banner) {
        banner.style.transform = 'translateY(100%)';
        setTimeout(() => {
            banner.style.display = 'none';
        }, 300);
    }
}

function acceptCookies() {
    setCookie('cookie_consent', 'accepted', 365);
    hideBanner();
    console.log('Cookies accepted');
}

function declineCookies() {
    setCookie('cookie_consent', 'declined', 365);
    hideBanner();
    console.log('Cookies declined');
}

function dismissCookies() {
    // Dismiss for 30 days
    setCookie('cookie_banner_dismissed', 'true', 30);
    hideBanner();
    console.log('Cookie banner dismissed');
}

// Function to initialize banner
function initCookieBanner() {
    const banner = document.getElementById('cookie-banner');
    
    if (!banner) {
        console.error('Cookie banner element not found in DOM!');
        return;
    }
    
    const consent = getCookie('cookie_consent');
    const dismissed = getCookie('cookie_banner_dismissed');
    
    if (!consent && !dismissed) {
        // Show banner with animation
        banner.style.display = 'block';
        // Force reflow for animation
        banner.offsetHeight;
        setTimeout(() => {
            banner.style.transform = 'translateY(0)';
        }, 50);
    } else {
        // Hide banner if cookies exist
        banner.style.display = 'none';
    }
}

// Check and show banner when page loads
(function() {
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initCookieBanner);
    } else {
        // DOM already loaded
        initCookieBanner();
    }
    
    // Also try after a short delay as fallback
    setTimeout(initCookieBanner, 200);
})();
</script>
