<div class="bg-gradient-to-r from-blue-600 via-purple-600 to-blue-600 text-white py-4 md:py-5 sticky bottom-0 z-40 shadow-2xl border-t-2 border-blue-400/30">
    <div class="container mx-auto px-4">
        <div class="flex flex-col sm:flex-row items-center justify-between gap-4">
            <div class="text-center sm:text-left flex items-center">
                <svg class="w-6 h-6 mr-3 text-yellow-300 animate-pulse" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
                </svg>
                <p class="font-bold text-base sm:text-lg">Need help? Get in touch today!</p>
            </div>
            <div class="flex flex-col sm:flex-row gap-3 w-full sm:w-auto">
                <?php if (isset($business['contact']['phone'])): ?>
                <a href="tel:<?php echo e($business['contact']['phone_formatted'] ?? $business['contact']['phone']); ?>" 
                   class="btn-modern bg-white text-blue-600 px-6 sm:px-8 py-3 rounded-xl font-bold hover:bg-gray-100 hover:scale-105 shadow-lg transition-all duration-300 text-center text-sm sm:text-base whitespace-nowrap">
                    📞 Call <?php echo e($business['contact']['phone']); ?>
                </a>
                <?php endif; ?>
                <a href="/contact" 
                   class="btn-modern bg-blue-700/90 backdrop-blur-sm text-white px-6 sm:px-8 py-3 rounded-xl font-bold hover:bg-blue-800 hover:scale-105 shadow-lg transition-all duration-300 text-center text-sm sm:text-base whitespace-nowrap border-2 border-blue-500/50">
                    📅 Book Online
                </a>
            </div>
        </div>
    </div>
</div>
