<?php
// Get current page info
$current_slug = get_current_slug();
$page_title = SITE_NAME;
$page_description = (isset($business) && is_array($business) && isset($business['description'])) 
    ? $business['description'] 
    : 'Professional automotive services in Coventry';
$page_keywords = '';

// Determine page-specific meta
if ($current_slug === 'home' || $current_slug === '') {
    if (isset($business) && is_array($business)) {
        $page_title = ($business['name'] ?? SITE_NAME) . ' | ' . ($business['tagline'] ?? '');
        $page_description = $business['description'] ?? $page_description;
    }
} elseif (strpos($current_slug, 'services/') === 0) {
    $service_slug = str_replace('services/', '', $current_slug);
    $service = get_service_by_slug($service_slug);
    if ($service) {
        $page_title = $service['meta_title'] ?? $service['title'] . ' | ' . SITE_NAME;
        $page_description = $service['meta_description'] ?? $service['short'];
        $page_keywords = $service['primary_keyword'] . ', ' . implode(', ', $service['secondary_keywords'] ?? []);
    }
} elseif (isset($pages_data) && is_array($pages_data) && isset($pages_data[$current_slug])) {
    $page_info = $pages_data[$current_slug];
    $page_title = $page_info['meta_title'] ?? $page_info['title'] . ' | ' . SITE_NAME;
    $page_description = $page_info['meta_description'] ?? $page_description;
}

$canonical_url = get_canonical_url($current_slug === 'home' ? '' : $current_slug);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0, user-scalable=yes">
    <meta name="format-detection" content="telephone=yes">
    <title><?php echo e($page_title); ?></title>
    <meta name="description" content="<?php echo e($page_description); ?>">
    <?php if ($page_keywords): ?>
    <meta name="keywords" content="<?php echo e($page_keywords); ?>">
    <?php endif; ?>
    
    <!-- Canonical URL -->
    <link rel="canonical" href="<?php echo e($canonical_url); ?>">
    
    <!-- Open Graph -->
    <meta property="og:title" content="<?php echo e($page_title); ?>">
    <meta property="og:description" content="<?php echo e($page_description); ?>">
    <meta property="og:url" content="<?php echo e($canonical_url); ?>">
    <meta property="og:type" content="website">
    <meta property="og:site_name" content="<?php echo e(SITE_NAME); ?>">
    
    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title" content="<?php echo e($page_title); ?>">
    <meta name="twitter:description" content="<?php echo e($page_description); ?>">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Custom Modern Styles -->
    <style>
        [x-cloak] { display: none !important; }
        
        /* Modern Animations */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        @keyframes slideInRight {
            from {
                opacity: 0;
                transform: translateX(-30px);
            }
            to {
                opacity: 1;
                transform: translateX(0);
            }
        }
        
        @keyframes pulse {
            0%, 100% {
                opacity: 1;
            }
            50% {
                opacity: 0.7;
            }
        }
        
        .animate-fade-in-up {
            animation: fadeInUp 0.6s ease-out;
        }
        
        .animate-slide-in-right {
            animation: slideInRight 0.6s ease-out;
        }
        
        /* Glassmorphism Effect */
        .glass {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            -webkit-backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        /* Modern Gradient Backgrounds */
        .gradient-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .gradient-secondary {
            background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
        }
        
        .gradient-blue {
            background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);
        }
        
        /* Smooth Transitions */
        * {
            transition: all 0.3s ease;
        }
        
        /* Modern Card Hover Effects */
        .card-hover {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        .card-hover:hover {
            transform: translateY(-8px);
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
        }
        
        /* Modern Button Styles */
        .btn-modern {
            position: relative;
            overflow: hidden;
            transition: all 0.3s ease;
        }
        
        .btn-modern::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.3);
            transform: translate(-50%, -50%);
            transition: width 0.6s, height 0.6s;
        }
        
        .btn-modern:hover::before {
            width: 300px;
            height: 300px;
        }
        
        /* Modern Input Focus */
        input:focus, select:focus, textarea:focus {
            outline: none;
            ring: 2px;
            ring-color: #667eea;
            border-color: #667eea;
        }
    </style>
    
    <!-- Schema.org LocalBusiness -->
    <?php if (isset($business) && is_array($business) && !empty($business)): ?>
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "AutoRepair",
        "name": "<?php echo e($business['name'] ?? SITE_NAME); ?>",
        "image": "<?php echo SITE_URL; ?>/assets/logo.png",
        "@id": "<?php echo SITE_URL; ?>",
        "url": "<?php echo SITE_URL; ?>",
        "telephone": "<?php echo e(isset($business['contact']['phone']) ? $business['contact']['phone'] : ''); ?>",
        "address": {
            "@type": "PostalAddress",
            "streetAddress": "<?php echo e(isset($business['contact']['address']['street']) ? $business['contact']['address']['street'] : ''); ?>",
            "addressLocality": "<?php echo e(isset($business['contact']['address']['city']) ? $business['contact']['address']['city'] : 'Coventry'); ?>",
            "postalCode": "<?php echo e(isset($business['contact']['address']['postcode']) ? $business['contact']['address']['postcode'] : ''); ?>",
            "addressCountry": "GB"
        },
        "geo": {
            "@type": "GeoCoordinates",
            "latitude": <?php echo isset($business['contact']['coordinates']['lat']) ? $business['contact']['coordinates']['lat'] : 52.4068; ?>,
            "longitude": <?php echo isset($business['contact']['coordinates']['lng']) ? $business['contact']['coordinates']['lng'] : -1.5197; ?>
        },
        "openingHoursSpecification": [
            <?php
            if (isset($business['opening_hours']) && is_array($business['opening_hours'])) {
                $hours = $business['opening_hours'];
                $days = ['monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday', 'sunday'];
                $day_map = ['monday' => 'Mo', 'tuesday' => 'Tu', 'wednesday' => 'We', 'thursday' => 'Th', 'friday' => 'Fr', 'saturday' => 'Sa', 'sunday' => 'Su'];
                $hours_spec = [];
                foreach ($days as $day) {
                    if (isset($hours[$day]) && !($hours[$day]['closed'] ?? false)) {
                        $hours_spec[] = '{
                            "@type": "OpeningHoursSpecification",
                            "dayOfWeek": "' . $day_map[$day] . '",
                            "opens": "' . ($hours[$day]['open'] ?? '08:00') . '",
                            "closes": "' . ($hours[$day]['close'] ?? '17:00') . '"
                        }';
                    }
                }
                echo implode(',', $hours_spec);
            }
            ?>
        ],
        "priceRange": "$$",
        "areaServed": {
            "@type": "City",
            "name": "Coventry"
        }
    }
    </script>
    <?php endif; ?>
</head>
<body class="bg-gradient-to-br from-gray-50 via-white to-gray-100 text-gray-900 antialiased">
    <!-- Modern Navigation with Glassmorphism -->
    <nav class="glass bg-white/95 backdrop-blur-md shadow-lg sticky top-0 z-50 border-b border-gray-200/50">
        <div class="container mx-auto px-4">
            <div class="flex justify-between items-center py-4">
                <a href="/" class="text-2xl font-bold bg-gradient-to-r from-blue-600 to-purple-600 bg-clip-text text-transparent hover:from-blue-700 hover:to-purple-700 transition-all duration-300">
                    <?php echo e($business['name'] ?? SITE_NAME); ?>
                </a>
                <button id="mobile-menu-toggle" class="md:hidden p-2 rounded-lg text-gray-700 hover:bg-gray-100 hover:text-blue-600 transition-all duration-300">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                    </svg>
                </button>
                <div id="nav-menu" class="hidden md:flex space-x-1">
                    <a href="/" class="px-4 py-2 rounded-lg text-gray-700 hover:bg-gradient-to-r hover:from-blue-50 hover:to-purple-50 hover:text-blue-600 transition-all duration-300 <?php echo $current_slug === 'home' || $current_slug === '' ? 'bg-gradient-to-r from-blue-50 to-purple-50 text-blue-600 font-semibold' : ''; ?>">Home</a>
                    <a href="/services" class="px-4 py-2 rounded-lg text-gray-700 hover:bg-gradient-to-r hover:from-blue-50 hover:to-purple-50 hover:text-blue-600 transition-all duration-300 <?php echo $current_slug === 'services' ? 'bg-gradient-to-r from-blue-50 to-purple-50 text-blue-600 font-semibold' : ''; ?>">Services</a>
                    <a href="/pricing" class="px-4 py-2 rounded-lg text-gray-700 hover:bg-gradient-to-r hover:from-blue-50 hover:to-purple-50 hover:text-blue-600 transition-all duration-300 <?php echo $current_slug === 'pricing' ? 'bg-gradient-to-r from-blue-50 to-purple-50 text-blue-600 font-semibold' : ''; ?>">Pricing</a>
                    <a href="/about" class="px-4 py-2 rounded-lg text-gray-700 hover:bg-gradient-to-r hover:from-blue-50 hover:to-purple-50 hover:text-blue-600 transition-all duration-300 <?php echo $current_slug === 'about' ? 'bg-gradient-to-r from-blue-50 to-purple-50 text-blue-600 font-semibold' : ''; ?>">About</a>
                    <a href="/reviews" class="px-4 py-2 rounded-lg text-gray-700 hover:bg-gradient-to-r hover:from-blue-50 hover:to-purple-50 hover:text-blue-600 transition-all duration-300 <?php echo $current_slug === 'reviews' ? 'bg-gradient-to-r from-blue-50 to-purple-50 text-blue-600 font-semibold' : ''; ?>">Reviews</a>
                    <a href="/contact" class="px-4 py-2 rounded-lg bg-gradient-to-r from-blue-600 to-purple-600 text-white hover:from-blue-700 hover:to-purple-700 shadow-md hover:shadow-lg transition-all duration-300 <?php echo $current_slug === 'contact' ? 'ring-2 ring-blue-300' : ''; ?>">Contact</a>
                </div>
            </div>
            <!-- Mobile Menu with Animation -->
            <div id="mobile-menu" class="hidden md:hidden pb-4 border-t border-gray-200/50 mt-2 pt-4 animate-fade-in-up">
                <a href="/" class="block py-3 px-4 rounded-lg text-gray-700 hover:bg-gradient-to-r hover:from-blue-50 hover:to-purple-50 hover:text-blue-600 transition-all duration-300 <?php echo $current_slug === 'home' || $current_slug === '' ? 'bg-gradient-to-r from-blue-50 to-purple-50 text-blue-600 font-semibold' : ''; ?>">Home</a>
                <a href="/services" class="block py-3 px-4 rounded-lg text-gray-700 hover:bg-gradient-to-r hover:from-blue-50 hover:to-purple-50 hover:text-blue-600 transition-all duration-300 <?php echo $current_slug === 'services' ? 'bg-gradient-to-r from-blue-50 to-purple-50 text-blue-600 font-semibold' : ''; ?>">Services</a>
                <a href="/pricing" class="block py-3 px-4 rounded-lg text-gray-700 hover:bg-gradient-to-r hover:from-blue-50 hover:to-purple-50 hover:text-blue-600 transition-all duration-300 <?php echo $current_slug === 'pricing' ? 'bg-gradient-to-r from-blue-50 to-purple-50 text-blue-600 font-semibold' : ''; ?>">Pricing</a>
                <a href="/about" class="block py-3 px-4 rounded-lg text-gray-700 hover:bg-gradient-to-r hover:from-blue-50 hover:to-purple-50 hover:text-blue-600 transition-all duration-300 <?php echo $current_slug === 'about' ? 'bg-gradient-to-r from-blue-50 to-purple-50 text-blue-600 font-semibold' : ''; ?>">About</a>
                <a href="/reviews" class="block py-3 px-4 rounded-lg text-gray-700 hover:bg-gradient-to-r hover:from-blue-50 hover:to-purple-50 hover:text-blue-600 transition-all duration-300 <?php echo $current_slug === 'reviews' ? 'bg-gradient-to-r from-blue-50 to-purple-50 text-blue-600 font-semibold' : ''; ?>">Reviews</a>
                <a href="/contact" class="block py-3 px-4 rounded-lg bg-gradient-to-r from-blue-600 to-purple-600 text-white hover:from-blue-700 hover:to-purple-700 shadow-md transition-all duration-300">Contact</a>
            </div>
        </div>
    </nav>
    
    <script>
        // Mobile menu toggle
        document.getElementById('mobile-menu-toggle')?.addEventListener('click', function() {
            const menu = document.getElementById('mobile-menu');
            menu.classList.toggle('hidden');
        });
    </script>
