<!-- Modern Review Submission Modal -->
<div id="review-modal" class="fixed inset-0 bg-black/60 backdrop-blur-sm z-50 hidden items-center justify-center p-4" style="display: none;">
    <div class="bg-white rounded-3xl shadow-2xl max-w-2xl w-full max-h-[90vh] overflow-y-auto transform transition-all border border-gray-200">
        <!-- Modal Header -->
        <div class="bg-gradient-to-r from-indigo-600 via-purple-600 to-pink-600 text-white p-6 rounded-t-3xl">
            <div class="flex items-center justify-between">
                <div class="flex items-center gap-3">
                    <div class="w-12 h-12 bg-white/20 backdrop-blur-sm rounded-xl flex items-center justify-center">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z"></path>
                        </svg>
                    </div>
                    <div>
                        <h2 class="text-2xl font-bold">Share Your Experience</h2>
                        <p class="text-white/90 text-sm">Help others by leaving a review</p>
                    </div>
                </div>
                <button onclick="closeReviewModal()" 
                        class="text-white hover:text-gray-200 transition p-2 hover:bg-white/20 rounded-full"
                        aria-label="Close">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                    </svg>
                </button>
            </div>
        </div>
        
        <!-- Modal Body -->
        <div class="p-6 md:p-8">
            <form id="review-form" class="space-y-6">
                <!-- Name -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">
                        Your Name <span class="text-red-500">*</span>
                    </label>
                    <input type="text" 
                           id="review-name" 
                           name="name" 
                           required
                           class="w-full border-2 border-gray-200 rounded-xl px-4 py-3 focus:ring-2 focus:ring-purple-500 focus:border-purple-500 transition-all"
                           placeholder="John Smith">
                    <p class="text-xs text-gray-500 mt-1">Only your initials will be displayed</p>
                </div>
                
                <!-- Rating -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-3">
                        Rating <span class="text-red-500">*</span>
                    </label>
                    <div class="flex items-center gap-2" id="rating-stars">
                        <?php for ($i = 1; $i <= 5; $i++): ?>
                        <button type="button" 
                                class="rating-star w-12 h-12 text-gray-300 hover:text-yellow-400 transition-all transform hover:scale-110"
                                data-rating="<?php echo $i; ?>"
                                onclick="setRating(<?php echo $i; ?>)">
                            <svg class="w-full h-full" fill="currentColor" viewBox="0 0 20 20">
                                <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                            </svg>
                        </button>
                        <?php endfor; ?>
                    </div>
                    <input type="hidden" id="review-rating" name="rating" required>
                </div>
                
                <!-- Vehicle -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">
                        Vehicle <span class="text-red-500">*</span>
                    </label>
                    <input type="text" 
                           id="review-vehicle" 
                           name="vehicle" 
                           required
                           class="w-full border-2 border-gray-200 rounded-xl px-4 py-3 focus:ring-2 focus:ring-purple-500 focus:border-purple-500 transition-all"
                           placeholder="e.g., Ford Focus, BMW 3 Series">
                </div>
                
                <!-- Service -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">
                        Service Received
                    </label>
                    <select id="review-service" 
                            name="service"
                            class="w-full border-2 border-gray-200 rounded-xl px-4 py-3 focus:ring-2 focus:ring-purple-500 focus:border-purple-500 transition-all">
                        <option value="General Service">General Service</option>
                        <option value="MOT">MOT</option>
                        <option value="Full Service">Full Service</option>
                        <option value="Interim Service">Interim Service</option>
                        <option value="Brake Repair">Brake Repair</option>
                        <option value="Diagnostics">Diagnostics</option>
                        <option value="Air Conditioning">Air Conditioning</option>
                        <option value="Clutch Repair">Clutch Repair</option>
                        <option value="Tyres">Tyres</option>
                        <option value="Cambelt Replacement">Cambelt Replacement</option>
                        <option value="Other">Other</option>
                    </select>
                </div>
                
                <!-- Review Text -->
                <div>
                    <label class="block text-sm font-semibold text-gray-700 mb-2">
                        Your Review <span class="text-red-500">*</span>
                    </label>
                    <textarea id="review-text" 
                              name="text" 
                              required
                              rows="5"
                              minlength="10"
                              maxlength="1000"
                              class="w-full border-2 border-gray-200 rounded-xl px-4 py-3 focus:ring-2 focus:ring-purple-500 focus:border-purple-500 transition-all resize-none"
                              placeholder="Share your experience with us..."></textarea>
                    <p class="text-xs text-gray-500 mt-1">
                        <span id="char-count">0</span> / 1000 characters
                    </p>
                </div>
                
                <!-- Honeypot fields (hidden) -->
                <input type="text" name="website" style="display:none" tabindex="-1" autocomplete="off">
                <input type="text" name="url" style="display:none" tabindex="-1" autocomplete="off">
                
                <!-- Error/Success Messages -->
                <div id="review-message" class="hidden p-4 rounded-xl"></div>
                
                <!-- Submit Button -->
                <button type="submit" 
                        id="review-submit"
                        class="w-full bg-gradient-to-r from-indigo-600 via-purple-600 to-pink-600 text-white px-8 py-4 rounded-xl font-bold hover:from-indigo-700 hover:via-purple-700 hover:to-pink-700 shadow-lg hover:shadow-xl transition-all duration-300 transform hover:scale-105 disabled:opacity-50 disabled:cursor-not-allowed disabled:transform-none">
                    <span id="submit-text">Submit Review</span>
                    <span id="submit-loading" class="hidden">Submitting...</span>
                </button>
            </form>
        </div>
    </div>
</div>

<style>
#review-modal {
    animation: fadeIn 0.3s ease-out;
}

#review-modal .bg-white {
    animation: slideUp 0.3s ease-out;
}

#review-modal.hidden {
    animation: fadeOut 0.3s ease-in;
}

@keyframes fadeIn {
    from { opacity: 0; }
    to { opacity: 1; }
}

@keyframes fadeOut {
    from { opacity: 1; }
    to { opacity: 0; }
}

@keyframes slideUp {
    from {
        transform: translateY(20px);
        opacity: 0;
    }
    to {
        transform: translateY(0);
        opacity: 1;
    }
}

.rating-star.active {
    color: #fbbf24;
}
</style>

<script>
let selectedRating = 0;

function setRating(rating) {
    selectedRating = rating;
    document.getElementById('review-rating').value = rating;
    
    // Update star display
    const stars = document.querySelectorAll('.rating-star');
    stars.forEach((star, index) => {
        if (index < rating) {
            star.classList.add('active');
            star.classList.remove('text-gray-300');
            star.classList.add('text-yellow-400');
        } else {
            star.classList.remove('active');
            star.classList.remove('text-yellow-400');
            star.classList.add('text-gray-300');
        }
    });
}

function openReviewModal() {
    const modal = document.getElementById('review-modal');
    if (modal) {
        modal.classList.remove('hidden');
        modal.style.display = 'flex';
        document.body.style.overflow = 'hidden';
        // Reset form
        document.getElementById('review-form').reset();
        selectedRating = 0;
        document.getElementById('review-rating').value = '';
        const stars = document.querySelectorAll('.rating-star');
        stars.forEach(star => {
            star.classList.remove('active', 'text-yellow-400');
            star.classList.add('text-gray-300');
        });
        document.getElementById('review-message').classList.add('hidden');
    }
}

function closeReviewModal() {
    const modal = document.getElementById('review-modal');
    if (modal) {
        modal.classList.add('hidden');
        setTimeout(() => {
            modal.style.display = 'none';
            document.body.style.overflow = '';
        }, 300);
    }
}

// Character counter
document.getElementById('review-text')?.addEventListener('input', function(e) {
    const count = e.target.value.length;
    document.getElementById('char-count').textContent = count;
});

// Form submission
document.getElementById('review-form')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const submitBtn = document.getElementById('review-submit');
    const submitText = document.getElementById('submit-text');
    const submitLoading = document.getElementById('submit-loading');
    const messageDiv = document.getElementById('review-message');
    
    // Validate rating
    if (selectedRating === 0) {
        showMessage('Please select a rating', 'error');
        return;
    }
    
    // Disable submit button
    submitBtn.disabled = true;
    submitText.classList.add('hidden');
    submitLoading.classList.remove('hidden');
    messageDiv.classList.add('hidden');
    
    // Get form data
    const formData = {
        name: document.getElementById('review-name').value.trim(),
        rating: selectedRating,
        vehicle: document.getElementById('review-vehicle').value.trim(),
        service: document.getElementById('review-service').value,
        text: document.getElementById('review-text').value.trim(),
        website: document.querySelector('input[name="website"]').value,
        url: document.querySelector('input[name="url"]').value
    };
    
    try {
        const response = await fetch('/api/review.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(formData)
        });
        
        const result = await response.json();
        
        if (result.success) {
            showMessage(result.message || 'Thank you for your review!', 'success');
            // Reset form
            setTimeout(() => {
                document.getElementById('review-form').reset();
                selectedRating = 0;
                document.getElementById('review-rating').value = '';
                const stars = document.querySelectorAll('.rating-star');
                stars.forEach(star => {
                    star.classList.remove('active', 'text-yellow-400');
                    star.classList.add('text-gray-300');
                });
                // Close modal after 2 seconds
                setTimeout(() => {
                    closeReviewModal();
                    // Reload page to show new review
                    window.location.reload();
                }, 2000);
            }, 1000);
        } else {
            showMessage(result.message || 'Failed to submit review. Please try again.', 'error');
            submitBtn.disabled = false;
            submitText.classList.remove('hidden');
            submitLoading.classList.add('hidden');
        }
    } catch (error) {
        console.error('Error:', error);
        showMessage('An error occurred. Please try again later.', 'error');
        submitBtn.disabled = false;
        submitText.classList.remove('hidden');
        submitLoading.classList.add('hidden');
    }
});

function showMessage(message, type) {
    const messageDiv = document.getElementById('review-message');
    messageDiv.classList.remove('hidden');
    messageDiv.textContent = message;
    
    if (type === 'success') {
        messageDiv.className = 'p-4 rounded-xl bg-green-50 text-green-800 border-2 border-green-200';
    } else {
        messageDiv.className = 'p-4 rounded-xl bg-red-50 text-red-800 border-2 border-red-200';
    }
}

// Close modal when clicking outside
document.getElementById('review-modal')?.addEventListener('click', function(e) {
    if (e.target === this) {
        closeReviewModal();
    }
});

// Close modal with Escape key
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        const modal = document.getElementById('review-modal');
        if (modal && modal.style.display !== 'none') {
            closeReviewModal();
        }
    }
});
</script>
