<?php
/**
 * Route Definitions
 * Centralized routing configuration for the website
 */

return [
    // Homepage
    '/' => [
        'file' => 'views/index.php',
        'title' => 'Home',
        'method' => 'GET'
    ],
    
    // Main Pages
    '/services' => [
        'file' => 'views/services.php',
        'title' => 'Services',
        'method' => 'GET'
    ],
    
    '/pricing' => [
        'file' => 'views/pricing.php',
        'title' => 'Pricing',
        'method' => 'GET'
    ],
    
    '/about' => [
        'file' => 'views/about.php',
        'title' => 'About',
        'method' => 'GET'
    ],
    
    '/contact' => [
        'file' => 'views/contact.php',
        'title' => 'Contact',
        'method' => 'GET|POST'
    ],
    
    '/reviews' => [
        'file' => 'views/reviews.php',
        'title' => 'Reviews',
        'method' => 'GET'
    ],
    
    '/faq' => [
        'file' => 'views/faq.php',
        'title' => 'FAQ',
        'method' => 'GET'
    ],
    
    '/sitemap' => [
        'file' => 'views/sitemap.php',
        'title' => 'Sitemap',
        'method' => 'GET'
    ],
    
    // Policy Pages
    '/privacy-policy' => [
        'file' => 'views/privacy-policy.php',
        'title' => 'Privacy Policy',
        'method' => 'GET'
    ],
    
    '/cookie-policy' => [
        'file' => 'views/cookie-policy.php',
        'title' => 'Cookie Policy',
        'method' => 'GET'
    ],
    
    '/terms' => [
        'file' => 'views/terms.php',
        'title' => 'Terms of Service',
        'method' => 'GET'
    ],
    
    // Dynamic Routes - Service Pages
    '/services/{slug}' => [
        'file' => 'views/service-detail.php',
        'title' => 'Service',
        'method' => 'GET',
        'params' => ['slug']
    ],
    
    // API Routes
    '/api/quote' => [
        'file' => 'api/quote.php',
        'title' => 'Quote API',
        'method' => 'POST',
        'api' => true
    ],
    
    '/api/quote.php' => [
        'file' => 'api/quote.php',
        'title' => 'Quote API',
        'method' => 'POST',
        'api' => true
    ],
    
    '/api/review' => [
        'file' => 'api/review.php',
        'title' => 'Review API',
        'method' => 'POST',
        'api' => true
    ],
    
    '/api/analytics-event' => [
        'file' => 'api/analytics-event.php',
        'title' => 'Analytics Event API',
        'method' => 'POST',
        'api' => true
    ],
    
    '/api/review.php' => [
        'file' => 'api/review.php',
        'title' => 'Review API',
        'method' => 'POST',
        'api' => true
    ],
    
    // XML Sitemap
    '/sitemap.xml' => [
        'file' => 'sitemap.xml.php',
        'title' => 'Sitemap XML',
        'method' => 'GET',
        'api' => true
    ],
    
    // Manual Sitemap Ping (requires secret key)
    '/ping-sitemap' => [
        'file' => 'ping-sitemap.php',
        'title' => 'Ping Sitemap',
        'method' => 'GET',
        'api' => true
    ],
    
    // Analytics Dashboard
    '/gsadm' => [
        'file' => 'gsadm/index.php',
        'title' => 'Analytics Dashboard',
        'method' => 'GET|POST'
    ],
];
