<?php
// 404 Error Page
// Can be included directly or accessed via router

if (!defined('BASE_PATH')) {
    require_once __DIR__ . '/../config.php';
}

http_response_code(404);

// Set current slug if not already set
if (!isset($GLOBALS['current_slug'])) {
    $current_slug = '404';
    $GLOBALS['current_slug'] = $current_slug;
} else {
    $current_slug = $GLOBALS['current_slug'];
}
?>
<?php include __DIR__ . '/../partials/header.php'; ?>

<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <div class="max-w-2xl mx-auto text-center">
            <h1 class="text-6xl font-bold text-gray-900 mb-4">404</h1>
            <h2 class="text-3xl font-bold mb-4">Page Not Found</h2>
            <p class="text-gray-600 mb-8">
                Sorry, the page you're looking for doesn't exist or has been moved.
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="/" class="bg-blue-600 text-white px-8 py-3 rounded-lg font-semibold hover:bg-blue-700 transition">
                    Go Home
                </a>
                <a href="/services" class="bg-gray-200 text-gray-800 px-8 py-3 rounded-lg font-semibold hover:bg-gray-300 transition">
                    View Services
                </a>
            </div>
        </div>
    </div>
</section>

<?php include __DIR__ . '/../partials/footer.php'; ?>
