<?php
require_once __DIR__ . '/../config.php';
$current_slug = 'about';
$about_data = $pages_data['about'] ?? [];
?>
<?php include __DIR__ . '/../partials/header.php'; ?>
<?php include __DIR__ . '/../partials/breadcrumbs.php'; ?>

<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto">
            <h1 class="text-4xl font-bold text-center mb-4"><?php echo e($about_data['title'] ?? 'About Us'); ?></h1>
            
            <?php if (isset($about_data['sections'])): ?>
                <?php foreach ($about_data['sections'] as $section): ?>
                <div class="mb-12">
                    <h2 class="text-2xl font-bold mb-4"><?php echo e($section['heading']); ?></h2>
                    <p class="text-lg text-gray-700 leading-relaxed"><?php echo e($section['content']); ?></p>
                </div>
                <?php endforeach; ?>
            <?php endif; ?>
            
            <!-- Certifications -->
            <?php if (isset($business['certifications']) && count($business['certifications']) > 0): ?>
            <div class="bg-blue-50 rounded-lg p-6 mt-8">
                <h2 class="text-2xl font-bold mb-4">Certifications & Standards</h2>
                <ul class="space-y-2">
                    <?php foreach ($business['certifications'] as $cert): ?>
                    <li class="flex items-start">
                        <svg class="w-6 h-6 text-green-500 mr-3 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                        <span class="text-gray-700"><?php echo e($cert); ?></span>
                    </li>
                    <?php endforeach; ?>
                </ul>
            </div>
            <?php endif; ?>
            
            <!-- Specialties -->
            <?php if (isset($business['specialties']) && count($business['specialties']) > 0): ?>
            <div class="mt-8">
                <h2 class="text-2xl font-bold mb-4">Our Specialties</h2>
                <div class="grid grid-cols-2 md:grid-cols-3 gap-4">
                    <?php foreach ($business['specialties'] as $specialty): ?>
                    <div class="bg-gray-50 rounded-lg p-4 text-center">
                        <span class="font-semibold text-gray-900"><?php echo e($specialty); ?></span>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <?php endif; ?>
            
            <div class="mt-12 text-center">
                <a href="/contact" class="inline-block bg-blue-600 text-white px-8 py-3 rounded-lg font-semibold hover:bg-blue-700 transition">
                    Get in Touch
                </a>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<?php include __DIR__ . '/../partials/cta-strip.php'; ?>

<?php include __DIR__ . '/../partials/footer.php'; ?>
