<?php
require_once __DIR__ . '/../config.php';
$current_slug = 'cookie-policy';
?>
<?php include __DIR__ . '/../partials/header.php'; ?>
<?php include __DIR__ . '/../partials/breadcrumbs.php'; ?>

<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto prose prose-lg">
            <h1 class="text-4xl font-bold mb-4">Cookie Policy</h1>
            <p class="text-gray-600 mb-8">Last updated: <?php echo date('F j, Y'); ?></p>
            
            <div class="space-y-6 text-gray-700">
                <div>
                    <h2 class="text-2xl font-bold mb-4">What Are Cookies?</h2>
                    <p>
                        Cookies are small text files that are placed on your device when you visit a website. They are widely used 
                        to make websites work more efficiently and provide information to website owners.
                    </p>
                </div>
                
                <div>
                    <h2 class="text-2xl font-bold mb-4">How We Use Cookies</h2>
                    <p>We use cookies for the following purposes:</p>
                    <ul class="list-disc pl-6 space-y-2">
                        <li><strong>Essential Cookies:</strong> Required for the website to function properly, such as remembering your cookie preferences.</li>
                        <li><strong>Analytics Cookies:</strong> Help us understand how visitors interact with our website (if analytics tools are implemented).</li>
                    </ul>
                </div>
                
                <div>
                    <h2 class="text-2xl font-bold mb-4">Types of Cookies We Use</h2>
                    <div class="space-y-4">
                        <div>
                            <h3 class="text-xl font-semibold mb-2">Essential Cookies</h3>
                            <p>
                                These cookies are necessary for the website to function and cannot be switched off. They are usually 
                                set in response to actions you take, such as setting your privacy preferences or filling in forms.
                            </p>
                        </div>
                        <div>
                            <h3 class="text-xl font-semibold mb-2">Performance Cookies</h3>
                            <p>
                                These cookies allow us to count visits and traffic sources so we can measure and improve site performance. 
                                They help us know which pages are most popular.
                            </p>
                        </div>
                    </div>
                </div>
                
                <div>
                    <h2 class="text-2xl font-bold mb-4">Managing Cookies</h2>
                    <p>
                        You can control and manage cookies in various ways. Please keep in mind that removing or blocking cookies 
                        can impact your user experience and parts of our website may no longer be fully accessible.
                    </p>
                    <p class="mt-4">
                        <strong>Cookie Banner Options:</strong>
                    </p>
                    <ul class="list-disc pl-6 space-y-2 mb-4">
                        <li><strong>Accept All:</strong> Allows all cookies (essential and analytics)</li>
                        <li><strong>Decline:</strong> Only essential cookies are used</li>
                        <li><strong>Dismiss:</strong> Closes the banner temporarily (will reappear on future visits)</li>
                    </ul>
                    <p class="mt-4">
                        Most browsers also allow you to:
                    </p>
                    <ul class="list-disc pl-6 space-y-2">
                        <li>See what cookies you have and delete them individually</li>
                        <li>Block third-party cookies</li>
                        <li>Block cookies from particular sites</li>
                        <li>Block all cookies</li>
                        <li>Delete all cookies when you close your browser</li>
                    </ul>
                    <p class="mt-4 p-4 bg-blue-50 rounded-lg border border-blue-200">
                        <strong>Note:</strong> You can change your cookie preferences at any time by clearing your browser cookies 
                        and refreshing the page. The cookie banner will reappear, allowing you to make a new choice.
                    </p>
                </div>
                
                <div>
                    <h2 class="text-2xl font-bold mb-4">Contact Us</h2>
                    <p>
                        If you have questions about our use of cookies, please contact us:
                    </p>
                    <p class="mt-4">
                        <strong><?php echo e($business['legal_name']); ?></strong><br>
                        Phone: <a href="tel:<?php echo e($business['contact']['phone_formatted']); ?>" class="text-blue-600 hover:text-blue-700"><?php echo e($business['contact']['phone']); ?></a><br>
                        Please use our <a href="/contact" class="text-blue-600 hover:text-blue-700">contact form</a> to get in touch with us.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include __DIR__ . '/../partials/footer.php'; ?>
