<?php
require_once __DIR__ . '/../config.php';
$current_slug = 'pricing';
?>
<?php include __DIR__ . '/../partials/header.php'; ?>
<?php include __DIR__ . '/../partials/breadcrumbs.php'; ?>

<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto">
            <h1 class="text-4xl font-bold text-center mb-4">Pricing & Estimates</h1>
            <p class="text-center text-gray-600 mb-12">
                <?php echo e($pages_data['pricing']['intro'] ?? 'Fair, transparent pricing for all our services.'); ?>
            </p>
            
            <!-- Quick Quote CTA -->
            <div class="bg-blue-50 rounded-lg p-6 mb-12 text-center">
                <h2 class="text-2xl font-bold mb-2">Get an Instant Estimate</h2>
                <p class="text-gray-700 mb-4">Use our quick quote calculator to get an estimate for your service needs.</p>
                <a href="/#quick-quote" class="inline-block bg-blue-600 text-white px-8 py-3 rounded-lg font-semibold hover:bg-blue-700 transition">
                    Try Quick Quote Calculator
                </a>
            </div>
            
            <!-- Pricing Bands -->
            <div class="space-y-8">
                <?php
                $pricing_bands = $pricing_data['pricing_bands'] ?? [];
                
                $pricing_categories = [
                    'MOT Testing' => ['mot'],
                    'Servicing' => ['servicing'],
                    'Brakes' => ['brakes'],
                    'Diagnostics' => ['diagnostics'],
                    'Air Conditioning' => ['aircon'],
                    'Clutch' => ['clutch'],
                    'Tyres' => ['tyres'],
                    'Cambelt' => ['cambelt']
                ];
                
                foreach ($pricing_categories as $category_name => $category_keys):
                    $has_data = false;
                    foreach ($category_keys as $key) {
                        if (isset($pricing_bands[$key])) {
                            $has_data = true;
                            break;
                        }
                    }
                    if (!$has_data) continue;
                ?>
                <div class="border border-gray-200 rounded-lg p-6">
                    <h2 class="text-2xl font-bold mb-4"><?php echo e($category_name); ?></h2>
                    <div class="space-y-4">
                        <?php
                        foreach ($category_keys as $key) {
                            if (!isset($pricing_bands[$key])) continue;
                            
                            $category_pricing = $pricing_bands[$key];
                            foreach ($category_pricing as $item_key => $item):
                                if (is_array($item) && isset($item['from'])):
                        ?>
                        <div class="flex justify-between items-start py-3 border-b border-gray-100 last:border-0">
                            <div class="flex-1">
                                <h3 class="font-semibold text-lg"><?php echo e(ucfirst(str_replace('_', ' ', $item_key))); ?></h3>
                                <?php if (isset($item['description'])): ?>
                                <p class="text-sm text-gray-600 mt-1"><?php echo e($item['description']); ?></p>
                                <?php endif; ?>
                                <?php if (isset($item['factors'])): ?>
                                <p class="text-xs text-gray-500 mt-2">
                                    Price varies by: <?php echo e(implode(', ', $item['factors'])); ?>
                                </p>
                                <?php endif; ?>
                            </div>
                            <div class="text-right ml-4">
                                <?php if (isset($item['fixed']) && $item['fixed']): ?>
                                <span class="text-2xl font-bold text-blue-600"><?php echo format_currency($item['from']); ?></span>
                                <?php else: ?>
                                <span class="text-2xl font-bold text-blue-600">
                                    From <?php echo format_currency($item['from']); ?>
                                </span>
                                <?php if (isset($item['to']) && $item['to'] > $item['from']): ?>
                                <span class="text-gray-600"> - <?php echo format_currency($item['to']); ?></span>
                                <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php
                                endif;
                            endforeach;
                        }
                        ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
            
            <!-- Disclaimers -->
            <?php if (isset($pricing_data['disclaimers']) && count($pricing_data['disclaimers']) > 0): ?>
            <div class="mt-12 bg-gray-50 rounded-lg p-6">
                <h2 class="text-xl font-bold mb-4">Important Notes</h2>
                <ul class="space-y-2 text-sm text-gray-700">
                    <?php foreach ($pricing_data['disclaimers'] as $disclaimer): ?>
                    <li class="flex items-start">
                        <span class="text-blue-600 mr-2">•</span>
                        <span><?php echo e($disclaimer); ?></span>
                    </li>
                    <?php endforeach; ?>
                </ul>
            </div>
            <?php endif; ?>
            
            <div class="mt-12 text-center">
                <a href="/contact" class="inline-block bg-blue-600 text-white px-8 py-3 rounded-lg font-semibold hover:bg-blue-700 transition">
                    Get a Detailed Quote
                </a>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<?php include __DIR__ . '/../partials/cta-strip.php'; ?>

<?php include __DIR__ . '/../partials/footer.php'; ?>
