<?php
require_once __DIR__ . '/../config.php';

// Get slug from route parameters (set by router) or fallback to $_GET
$slug = $_GET['slug'] ?? '';
$slug = sanitize_input($slug, 100);

// Validate slug format
if (empty($slug) || !validate_slug($slug)) {
    http_response_code(404);
    $current_slug = '404';
    include '404.php';
    exit;
}

$service = get_service_by_slug($slug);

if (!$service) {
    http_response_code(404);
    $current_slug = '404';
    include '404.php';
    exit;
}

// Set current slug if not already set by router
if (!isset($GLOBALS['current_slug'])) {
    $current_slug = 'services/' . $slug;
    $GLOBALS['current_slug'] = $current_slug;
} else {
    $current_slug = $GLOBALS['current_slug'];
}
?>
<?php include __DIR__ . '/../partials/header.php'; ?>
<?php include __DIR__ . '/../partials/breadcrumbs.php'; ?>

<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto">
            <div class="mb-8">
                <span class="text-6xl mb-4 block"><?php echo e($service['icon'] ?? '🔧'); ?></span>
                <h1 class="text-4xl font-bold mb-4"><?php echo e($service['title']); ?></h1>
                <p class="text-xl text-gray-600 mb-6"><?php echo e($service['short']); ?></p>
            </div>
            
            <div class="prose max-w-none mb-8">
                <p class="text-lg text-gray-700 leading-relaxed"><?php echo e($service['long']); ?></p>
            </div>
            
            <?php if (isset($service['benefits']) && count($service['benefits']) > 0): ?>
            <div class="bg-blue-50 rounded-lg p-6 mb-8">
                <h2 class="text-2xl font-bold mb-4">Benefits</h2>
                <ul class="space-y-2">
                    <?php foreach ($service['benefits'] as $benefit): ?>
                    <li class="flex items-start">
                        <svg class="w-6 h-6 text-green-500 mr-3 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                        <span class="text-gray-700"><?php echo e($benefit); ?></span>
                    </li>
                    <?php endforeach; ?>
                </ul>
            </div>
            <?php endif; ?>
            
            <?php if (isset($service['faqs']) && count($service['faqs']) > 0): ?>
            <div class="mb-8">
                <h2 class="text-2xl font-bold mb-4">Frequently Asked Questions</h2>
                <div class="space-y-4">
                    <?php foreach ($service['faqs'] as $faq): ?>
                    <div class="bg-gray-50 rounded-lg p-4">
                        <h3 class="font-semibold text-lg mb-2"><?php echo e($faq['question']); ?></h3>
                        <p class="text-gray-700"><?php echo e($faq['answer']); ?></p>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <?php endif; ?>
            
            <!-- Service Schema -->
            <script type="application/ld+json">
            {
                "@context": "https://schema.org",
                "@type": "Service",
                "serviceType": "<?php echo e($service['title']); ?>",
                "provider": {
                    "@type": "AutoRepair",
                    "name": "<?php echo e($business['name']); ?>",
                    "address": {
                        "@type": "PostalAddress",
                        "streetAddress": "<?php echo e($business['contact']['address']['street']); ?>",
                        "addressLocality": "<?php echo e($business['contact']['address']['city']); ?>",
                        "postalCode": "<?php echo e($business['contact']['address']['postcode']); ?>",
                        "addressCountry": "GB"
                    }
                },
                "areaServed": {
                    "@type": "City",
                    "name": "Coventry"
                }
            }
            </script>
            
            <!-- FAQ Schema -->
            <?php if (isset($service['faqs']) && count($service['faqs']) > 0): ?>
            <script type="application/ld+json">
            {
                "@context": "https://schema.org",
                "@type": "FAQPage",
                "mainEntity": [
                    <?php
                    $faq_items = [];
                    foreach ($service['faqs'] as $faq) {
                        $faq_items[] = '{
                            "@type": "Question",
                            "name": "' . e($faq['question']) . '",
                            "acceptedAnswer": {
                                "@type": "Answer",
                                "text": "' . e($faq['answer']) . '"
                            }
                        }';
                    }
                    echo implode(',', $faq_items);
                    ?>
                ]
            }
            </script>
            <?php endif; ?>
            
            <div class="mt-8 flex flex-col sm:flex-row gap-4">
                <a href="/contact" class="bg-blue-600 text-white px-8 py-3 rounded-lg font-semibold hover:bg-blue-700 transition text-center">
                    Book This Service
                </a>
                <a href="tel:<?php echo e($business['contact']['phone_formatted']); ?>" 
                   class="bg-gray-200 text-gray-800 px-8 py-3 rounded-lg font-semibold hover:bg-gray-300 transition text-center">
                    Call <?php echo e($business['contact']['phone']); ?>
                </a>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<?php include __DIR__ . '/../partials/cta-strip.php'; ?>

<?php include __DIR__ . '/../partials/footer.php'; ?>
