<?php
require_once __DIR__ . '/../config.php';
$current_slug = 'services';
?>
<?php include __DIR__ . '/../partials/header.php'; ?>
<?php include __DIR__ . '/../partials/breadcrumbs.php'; ?>

<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <h1 class="text-4xl font-bold text-center mb-4">Our Services</h1>
        <p class="text-center text-gray-600 mb-12 max-w-3xl mx-auto">
            Comprehensive automotive services for all makes and models in Coventry. 
            From MOT testing to complex repairs, we've got you covered.
        </p>
        
        <!-- Service Categories -->
        <?php
        $categories = [];
        foreach ($services_data['services'] as $service) {
            $cat = $service['category'] ?? 'Other';
            if (!isset($categories[$cat])) {
                $categories[$cat] = [];
            }
            $categories[$cat][] = $service;
        }
        ?>
        
        <?php foreach ($categories as $category => $category_services): ?>
        <div class="mb-12">
            <h2 class="text-2xl font-bold mb-6 text-gray-900"><?php echo e($category); ?></h2>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <?php foreach ($category_services as $service): ?>
                    <?php include __DIR__ . '/../partials/service-card.php'; ?>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</section>

<!-- CTA Section -->
<?php include __DIR__ . '/../partials/cta-strip.php'; ?>

<?php include __DIR__ . '/../partials/footer.php'; ?>
