<?php
require_once __DIR__ . '/../config.php';
$current_slug = 'terms';
?>
<?php include __DIR__ . '/../partials/header.php'; ?>
<?php include __DIR__ . '/../partials/breadcrumbs.php'; ?>

<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <div class="max-w-4xl mx-auto prose prose-lg">
            <h1 class="text-4xl font-bold mb-4">Terms of Service</h1>
            <p class="text-gray-600 mb-8">Last updated: <?php echo date('F j, Y'); ?></p>
            
            <div class="space-y-6 text-gray-700">
                <div>
                    <h2 class="text-2xl font-bold mb-4">Agreement to Terms</h2>
                    <p>
                        By accessing and using this website, you accept and agree to be bound by the terms and provision of this agreement.
                    </p>
                </div>
                
                <div>
                    <h2 class="text-2xl font-bold mb-4">Services</h2>
                    <p>
                        <?php echo e($business['legal_name']); ?> provides automotive repair and servicing services. All services are 
                        subject to availability and our terms of service. Prices are estimates until a vehicle inspection is completed.
                    </p>
                </div>
                
                <div>
                    <h2 class="text-2xl font-bold mb-4">Warranties</h2>
                    <p>
                        We provide warranties on workmanship and parts as specified at the time of service. Warranties do not cover 
                        normal wear and tear or damage caused by misuse or accidents.
                    </p>
                </div>
                
                <div>
                    <h2 class="text-2xl font-bold mb-4">Payment</h2>
                    <p>
                        Payment is due upon completion of work unless otherwise agreed. We accept cash, card payments, and bank transfers.
                    </p>
                </div>
                
                <div>
                    <h2 class="text-2xl font-bold mb-4">Limitation of Liability</h2>
                    <p>
                        Our liability is limited to the cost of the service provided. We are not liable for any indirect, 
                        consequential, or incidental damages.
                    </p>
                </div>
                
                <div>
                    <h2 class="text-2xl font-bold mb-4">Contact</h2>
                    <p>
                        For questions about these terms, please contact us:
                    </p>
                    <p class="mt-4">
                        <strong><?php echo e($business['legal_name']); ?></strong><br>
                        <?php echo e($business['contact']['address']['full']); ?><br>
                        Phone: <a href="tel:<?php echo e($business['contact']['phone_formatted']); ?>" class="text-blue-600 hover:text-blue-700"><?php echo e($business['contact']['phone']); ?></a><br>
                        Please use our <a href="/contact" class="text-blue-600 hover:text-blue-700">contact form</a> to get in touch with us.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<?php include __DIR__ . '/../partials/footer.php'; ?>
